--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A spell game object.
--- @class tes3spell : tes3object, tes3baseObject
--- @field alwaysSucceeds boolean A flag that determines if casting the spell will always succeed.
--- @field autoCalc boolean Determines if the magicka cost for the spell is autocalculated, and if the spell may be automatically assigned to NPCs if they are skillful enough to cast it.
--- @field basePurchaseCost number Calculates the base cost to purchase the spell. This value is not adjusted by mercantile skills.
--- @field castType tes3.spellType The spell's cast type. Maps to [`tes3.spellType`](https://mwse.github.io/MWSE/references/spell-types/) constants.
--- @field effects tes3effect[] *Read-only*. An array-style table of the [`tes3effect`](https://mwse.github.io/MWSE/types/tes3effect/) data on the object.
--- @field flags number A bit field for the spell's flags.
--- @field isAbility boolean *Read-only*. `true` if the spell is an ability. This is equivalent to checking the `.castType` property against the constant.
--- @field isActiveCast boolean *Read-only*. True if the spell is actively cast. If false, the spell's effects are always passively affecting the owner.
--- @field isBlightDisease boolean *Read-only*. `true` if the spell is a blight disease. This is equivalent to checking the `.castType` property against the constant.
--- @field isCommonDisease boolean *Read-only*. `true` if the spell is a common disease. This is equivalent to checking the `.castType` property against the constant.
--- @field isCorprusDisease boolean *Read-only*. `true` if the spell is a blight disease with a corprus effect. This is equivalent to checking the `.castType` property against the constant, combined with using `:hasEffect` to check for corprus.
--- @field isCurse boolean *Read-only*. `true` if the spell is a curse. This is equivalent to checking the `.castType` property against the constant.
--- @field isDisease boolean *Read-only*. `true` if the spell is a common or blight disease. This is equivalent to checking the `.castType` property against the constants.
--- @field isPower boolean *Read-only*. `true` if the spell is a power. This is equivalent to checking the `.castType` property against the constant.
--- @field isSpell boolean *Read-only*. `true` if the spell is a normal spell. This is equivalent to checking the `.castType` property against the constant.
--- @field magickaCost number The magicka used when attempting to cast this spell. For an auto-calculated spell, it is updated when the spell is created or loaded.
--- @field name string The name of the spell.
--- @field playerStart boolean A flag that determines if the spell may be assigned to the player at character generation if the player has enough skill to cast it.
--- @field value number *Read-only*. The calculated base price of the spell. This is the `magickaCost` of the spell multiplied by the `fSpellValueMult` GMST.
tes3spell = {}

--- Use [`tes3.createObject()`](https://mwse.github.io/MWSE/apis/tes3/#tes3createobject) instead. This function created a new spell object, which will be stored as part of the current saved game.
--- @deprecated
--- @param id string The new object's ID. Must be unique.
--- @param name? string *Optional*. The new object's name.
--- @return tes3spell newObject No description yet available.
function tes3spell.create(id, name) end

--- Calculates the chance that a caster can cast a given spell.
--- @param params tes3spell.calculateCastChance.params This table accepts the following values:
--- 
--- `checkMagicka?`: boolean — *Default*: `true`. Determines if the caster's magicka should be taken into account during the calculation.
--- 
--- `caster`: tes3reference|tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer — The caster to perform the calculation against.
--- @return number result No description yet available.
function tes3spell:calculateCastChance(params) end

---Table parameter definitions for `tes3spell.calculateCastChance`.
--- @class tes3spell.calculateCastChance.params
--- @field checkMagicka? boolean *Default*: `true`. Determines if the caster's magicka should be taken into account during the calculation.
--- @field caster tes3reference|tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The caster to perform the calculation against.

--- Creates a copy of this object.
--- @param params tes3spell.createCopy.params This table accepts the following values:
--- 
--- `id?`: string — *Optional*. The new object's ID. If one is not provided, a randomly generated one will be used.
--- 
--- `addToObjectList?`: boolean — *Default*: `true`. If true, the object will be added to the data handler. If this is false, the new object may not have a randomly generated ID. Do not use this without knowing the implications.
--- 
--- `sourceless?`: boolean — *Default*: `false`. If true, the object will be made sourceless, and will not be serialized to the save game. If the object is copied outside of a save game, the object will **always** be sourceless.
--- @return tes3spell newObject No description yet available.
function tes3spell:createCopy(params) end

---Table parameter definitions for `tes3spell.createCopy`.
--- @class tes3spell.createCopy.params
--- @field id? string *Optional*. The new object's ID. If one is not provided, a randomly generated one will be used.
--- @field addToObjectList? boolean *Default*: `true`. If true, the object will be added to the data handler. If this is false, the new object may not have a randomly generated ID. Do not use this without knowing the implications.
--- @field sourceless? boolean *Default*: `false`. If true, the object will be made sourceless, and will not be serialized to the save game. If the object is copied outside of a save game, the object will **always** be sourceless.

--- Gets the number of active effects in the spell effect table.
--- @return integer result No description yet available.
function tes3spell:getActiveEffectCount() end

--- Calculates and returns the magicka cost as if this spell was an autoCalc spell. It only returns the magicka value and does not update the spell's magickaCost.
--- @return number result No description yet available.
function tes3spell:getAutoCalcMagickaCost() end

--- Gets the first index of an effect ID in the spell effect table. Returns `-1` if provided effect doesn't exist in the spell.
--- @param effectId tes3.effect|integer A value from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @return integer index Returns 0-based index. Because Lua's arrays are 1-based, to index the spell's `effects` array with the return value add 1.
function tes3spell:getFirstIndexOfEffect(effectId) end

--- Returns the effect of the spell that a given actor is least proficient with.
--- @param actor tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer|tes3reference|tes3npc|tes3npcInstance The actor to calculate for. A mobile actor is preferred, as passing only a `tes3npc` will not use up to date skill information.
--- @return tes3effect|nil effect The least proficient effect, or `nil` if the spell has no valid effects.
function tes3spell:getLeastProficientEffect(actor) end

--- Returns the school of the least proficient effect on the spell, for a given actor.
--- @param actor tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer|tes3reference|tes3npc|tes3npcInstance The actor to calculate for. A mobile actor is preferred, as passing only a `tes3npc` will not use up to date skill information.
--- @return tes3.magicSchool|nil schoolID The least proficient school ID (from [`tes3.magicSchool`](https://mwse.github.io/MWSE/references/magic-schools/) table), or `nil` if the spell has no valid effects.
function tes3spell:getLeastProficientSchool(actor) end

--- Determines if the spell contains an effect with the given id.
--- @param effectId tes3.effect|integer A value from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @return boolean hasEffect Returns `true` if the spell contains the given effect id, otherwise `false`.
function tes3spell:hasEffect(effectId) end

